local assets=
{
	Asset("ANIM", "anim/nato556.zip"),
	Asset("ATLAS", "images/inventoryimages/nato556.xml"),
    Asset("IMAGE", "images/inventoryimages/nato556.tex"),
}

local prefabs =
{

}

local function OnHit(inst, owner, target)
    inst:Remove()    
end


local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("nato556")
    inst.AnimState:SetBuild("nato556")
    inst.AnimState:PlayAnimation("idle", false)
    		
    inst:AddTag("projectile")
	
				
    inst:AddComponent("stackable")	 
	inst.components.stackable.maxsize = 40
	
	inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(100)
	inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(OnHit)
	
    inst:AddComponent("inspectable")
    	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/nato556.xml"

	return inst
end



STRINGS.NAMES.NATO556 = "5.56x45mm"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.NATO556 = "Ammo for the NATO weapons."


return Prefab( "common/inventory/nato556", fncommon, assets)
